/**
 * Created by Administrator on 2016/8/22.
 */
appModule.controller('NoticeCommentCtrl', ["$scope", "notices", "pages", "api", "log", "utils", "$translate", "$timeout", function ($scope, notices, pages, api, log, utils, translate, $timeout) {
    $scope.COMMENT_MAX_LENGTH = 500;
    $scope.COMMENT_TYPE = translate.instant('preview.comment.title');
    $scope.REPLY_TYPE = translate.instant('preview.comment.reply');
    $scope.commentPlaceholder = translate.instant('preview.comment.input-placeholder', {type: $scope.COMMENT_TYPE});
    $scope.replyPlaceholder = translate.instant('preview.comment.input-placeholder', {type: $scope.REPLY_TYPE});
    $scope.currentUser = api.getCurrentUser();
    $scope.comments = {
        list: [],
        total_count: 0,
        board_info: null
    };
    $scope.getComments = function (maxId) {
        var id = maxId ? maxId : 0;
        $scope.isLoadingComment = true;
        api.getComments($scope.notice.id, id, function (data) {
            utils.applyScope($scope, function () {
                $scope.isLoadingComment = false;
                $scope.comments.board_info = data.board_info;
                if(!maxId){
                    $scope.comments.total_count = data.total_count;
                }

                $scope.comments.list = $scope.comments.list.concat(data.data);
            });
        }, function (msg) {
            utils.applyScope($scope, function () {
                $scope.isLoadingComment = false;
            });

            log.logInfo('fail to get comments: ' + msg);
        });
    };
    $scope.initSendingComment = function () {
        $scope.sendingComment = {
            bbs_id: $scope.notice.id,
            parent_id: 0,
            is_editor: $scope.notice.forceAvatar ? 1 : 0,
            content: ''
        };
    };


    $scope.isEditorComment = function(id){
        var comment = findComment(id,$scope.comments.list);
        return comment && comment.is_editor == 1;
    };

    $scope.publishComment = function (id, cm) {
        if ($scope.disableSendComment) {
            return;
        }
        if (!$scope.sendingComment.content) {
            api.notifyError(translate.instant('preview.comment.alert.no-comment'));
            return;
        }
        utils.requestMainWindowMethod('uc.modules.notice.NoticeManager', 'convertDomStrToMsg', [$scope.sendingComment.content], function (data) {
            $scope.sendingComment.content = data;
            if ($scope.sendingComment.content.length > $scope.COMMENT_MAX_LENGTH) {
                api.notifyError(translate.instant('preview.comment.alert.max-comment-length', {maxLength: $scope.COMMENT_MAX_LENGTH}));
                return;
            }
            if (id) {
                $scope.sendingComment.parent_id = id;
            } else {
                $scope.sendingComment.parent_id = 0;
            }
            $scope.disableSendComment = true;
            api.sendComment($scope.sendingComment, function (data) {
                $scope.disableSendComment = false;
                $scope.initSendingComment();
                utils.applyScope($scope, function () {
                    $scope.$broadcast('clearInput');
                    if (!data.parent_id) {
                        $scope.comments.list.unshift(data);
                        $scope.comments.total_count++;
                        pages.fnCall('notice', 'updateCommentCount', {
                            noticeId: $scope.notice.id,
                            commentCount: $scope.comments.total_count
                        }, function () {
                        });
                    } else {
                        var index = $scope.comments.list.findIndex(function (cm) {
                            return cm.id === data.comment_id;
                        });
                        if (index > -1) {
                            if (!$scope.comments.list[index].reply_list) {
                                $scope.comments.list[index].reply_list = [];
                            }
                            $scope.comments.list[index].reply_list.push(data);
                        }

                        $scope.toggleReply(cm);
                    }
                });
            }, function (msg, errorCode) {
                log.logInfo('fail to send comment: ' + msg);
                $scope.initSendingComment();
                if (errorCode == api.errorCodes.comment.noNotice) {
                    var option = {
                        msg: msg,
                        onConfirm: function () {
                            utils.applyScope($scope, function () {
                                $scope.onClose();
                            });
                        },
                        onCancel: null,
                        isShowCancel: false
                    };
                    api.notifyError(option);
                    return;
                }

                $scope.disableSendComment = false;
                if (errorCode == api.errorCodes.comment.noComment && cm) {
                    var option = {
                        msg: translate.instant('common.error.' + api.errorCodes.comment.noComment, {commentType: $scope.getCommentType(cm)}),
                        onConfirm: function () {
                            utils.applyScope($scope, function () {
                                $scope.updateOneCommentInfo(cm.comment_id ? cm.comment_id : cm.id); //当前回复的是评论时，comment_id为0，所以要取id
                            });
                        },
                        onCancel: null,
                        isShowCancel: false
                    };
                    api.notifyError(option);
                    return;
                }
                api.notifyError(msg);
            });
        });
    };

    $scope.onScrollDown = function () {
        if ($scope.comments.list.length > 0) {
            $scope.getComments($scope.comments.list[$scope.comments.list.length - 1].id);
        }
    };

    $scope.getCommentType = function (comment) {
        return comment.comment_id ? translate.instant('preview.comment.reply-by-editor') : translate.instant('preview.comment.comment-by-editor');
    }

    $scope.removeComment = function (comment) {
        var id = comment.id;
        if (id) {
            api.notifyError({
                msg: translate.instant('preview.comment.alert.remove-comment', {type: $scope.getCommentType(comment)}),
                onConfirm: function () {
                    api.removeComment(id, function (data) {
                        utils.applyScope($scope, function () {
                            if (!comment.comment_id) { // 此评论是主评论
                                for (var i = 0; i < $scope.comments.list.length; i++) {
                                    if ($scope.comments.list[i].id === comment.id) {
                                        $scope.comments.list.splice(i, 1);
                                        $scope.comments.total_count--;
                                        pages.fnCall('notice', 'updateCommentCount', {
                                            noticeId: $scope.notice.id,
                                            commentCount: $scope.comments.total_count
                                        }, function () {
                                        });
                                        return;
                                    }
                                }
                            } else {
                                var index = $scope.comments.list.findIndex(function (cm) {
                                    return cm.id === comment.comment_id;
                                });
                                if (Array.isArray(data) && data.length == 0) {
                                    $scope.comments.list.splice(index, 1);
                                } else {
                                    $scope.comments.list.splice(index, 1, data);
                                }
                            }
                        });
                    }, function (msg) {
                        log.logInfo('fail to remove comment: ' + msg);
                        var option = {
                            msg: msg,
                            onConfirm: function () {
                                if (!comment.comment_id) {
                                    utils.applyScope($scope, function () {
                                        var index = $scope.comments.list.findIndex(function (cm) {
                                            return cm.id === comment.id;
                                        });
                                        if (index > -1) {
                                            $scope.comments.list.splice(index, 1);
                                        }
                                    });
                                } else {
                                    $scope.updateOneCommentInfo(comment.comment_id);
                                }
                            },
                            onCancel: null,
                            isShowCancel: false
                        };
                        api.notifyError(option);
                    });
                }
            });
        }
    };

    $scope.updateOneCommentInfo = function (commentId) {
        var index = $scope.comments.list.findIndex(function (cm) {
            return cm.id === commentId;
        });
        if (index > -1) {
            api.getOneComment(commentId, function (data) {
                utils.applyScope($scope, function () {
                    $scope.comments.list.splice(index, 1, data);
                });
            }, function (msg, errorCode) {
                if (errorCode == api.errorCodes.comment.noComment) {
                    utils.applyScope($scope, function () {
                        $scope.comments.list.splice(index, 1);
                    });
                } else {
                    log.logInfo('fail to get one comment: ' + msg);
                }
            });
        }
    };

    $scope.canDeleteComment = function (comment) {
        if ($scope.sendingComment.is_editor) {
            return true;
        }
        return comment.user_id == $scope.currentUser.userId && !comment.is_editor;
    };

    $scope.toggleReply = function (comment) {
        if (!comment.isShowReply) {
            $scope.hideReply($scope.comments.list);
            comment.isShowReply = !comment.isShowReply;
            $timeout(function () {
                $scope.$emit('bbsCommentScrollChanged');
            }, 200);
        } else {
            $timeout(function () {
                comment.isShowReply = false;
            }, 300);
        }
        comment.isFocus = !comment.isFocus;
    };

    $scope.hideReply = function (comments) {
        comments.forEach(function (comment) {
            comment.isShowReply = false;
            comment.isFocus = false;
            if (comment.reply_list && comment.reply_list.length > 0) {
                $scope.hideReply(comment.reply_list);
            }
        });
    };

    function findComment(id, comments){
        var target = null;
        if(id && comments.length > 0){
            for(var i= 0; i<comments.length;i++){
                if(comments[i].id == id){
                    target = comments[i];
                    break;
                }else if(comments[i].reply_list && comments[i].reply_list.length>0){
                    target = findComment(id,comments[i].reply_list);
                }
            }
        }
        return target;
    }

    var stopWatchTotalCount = $scope.$watch("comments.total_count", function (newV) {
        if (newV != undefined) {
            $scope.totalCountTxt = '(' + $scope.comments.total_count + ')';
        }
    });
    var offGetComments = $scope.$on('getComments',function(){
        $scope.initSendingComment();
        var currentUser = api.getCurrentUser();

        if ($scope.notice.forceAvatar && typeof ($scope.notice.forceAvatar) == "string") {
            $scope.senderAvatar = $scope.notice.forceAvatar;
        } else {
            var avatar = currentUser.localAvatar ? currentUser.localAvatar : currentUser.remoteAvatarUrl;
            if (avatar) {
                $scope.senderAvatar = avatar;
            }
        }
        $scope.getComments();
    });
    var offScrollDown = $scope.$on("onScrollDown",function(e){
        $scope.onScrollDown();
    });


    $scope.$on('$destroy', function () {
        stopWatchTotalCount();
        offScrollDown();
    });
}]);